set more off
pause off
macro drop _all
graph set window fontface "Times New Roman"
cd ""
set seed 1073741823

global mainpath "/Users/ekurt/Desktop/MP ASYM/Stata"
cap log close
log using "${mainpath}/Log/DataPrep/4.Estimation Prep.log", replace

set fredkey 6c1fd093d59575985ff0da1f786415d5, permanently

import fred USRECM, aggregate(quarterly) clear

generate qdate = qofd(daten)
tsset qdate, quarterly

generate cyear = yofd(daten)
drop if cyear < 1970

drop if datestr == "2022-07-01" 

tempfile recdates
save `recdates'

use "${mainpath}/Data/Quarter_LP_Ready3.dta",clear

drop _merge
merge m:1 qdate using `recdates', keep(1 3) 

drop if _merge == 1 

drop _merge

xtset gvkeyn qdate
sort gvkeyn qdate

by gvkeyn: replace fyrc = fyrc[_n-1] if fyrc ==.

sort gvkeyn qdate

cap drop empYComp2
gen empYComp2 = empYComp if cquarter ==1
replace empYComp2 = . if cquarter !=1

cap drop life
cap drop empYComp3
by gvkeyn: gen life = _n
gen empYComp3 = empYComp2 
by gvkeyn: replace empYComp3 = empYComp if _n ==1 & cquarter[1] !=1
gen empYComp4 = empYComp3 

by gvkeyn: ipolate empYComp4 qdate, gen(empC_ipo)

label var empC_ipo "Number of Employees" 

cap rename emp empY

by gvkeyn: gen realasset = atq/(gva_pindex/100)

gen logppentq = log(ppentq/(gva_pindex/100))*100

sort gvkeyn qdate

gen realcapx = capxq/(gva_pindex/100)
by gvkeyn: gen drealcapx = (realcapx - realcapx[_n-1])/realcapx[_n-1]

gen realppentq = ppentq/(gva_pindex/100)
by gvkeyn: gen drealppentq = (realppentq - realppentq[_n-1])

gen logrealcapx = log(realcapx)*100
sort gvkeyn qdate

rename dGS1_scaled gs1d

gen gs1dp = .
replace gs1dp = gs1d if gs1d >0
replace gs1dp = 0 if gs1dp == .

gen gs1dn = .
replace gs1dn = gs1d if gs1d <0
replace gs1dn = 0 if gs1dn == .

gen lnempC = ln(empC_ipo)*100
label var lnempC "Log Employees"

sort gvkeyn qdate

cap drop empgrowthC
by gvkeyn: gen empgrowthC = (empC_ipo-empC_ipo[_n-1])/empC_ipo[_n-1]
by gvkeyn: gen datq = (atq-atq[_n-1])/atq[_n-1]

by gvkeyn: gen dlogrealsales = lnRealSales- L.lnRealSales
by gvkeyn: gen dlogrealcapx = logrealcapx- L.logrealcapx

rename capex_netppe_c invratio


cap drop emptrim  
gen emptrim = . 

local startYear 1975 
local endYear 2019

foreach n of numlist `startYear'/`endYear' {
            quietly  sum empgrowthC if cyear ==`n' , det
              replace emptrim = 1 if empgrowthC > `r(p99)' & empgrowthC !=. & cyear == `n'
			  replace emptrim = 1 if empgrowthC < `r(p1)' & empgrowthC !=. & cyear == `n'

}


replace Trim_Baseline = 1 if emptrim ==1

drop if Trim_Baseline == 1  

save "${mainpath}/Data/Quarter_LP_Ready3_REGS.dta",replace

cap log close
